% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repdiversity.R
\name{repDiversity}
\alias{repDiversity}
\title{General function for the repertoire diversity estimation.}
\usage{
repDiversity(.data, .method = c("chao1", "gini.simp", "inv.simp", "gini",
  "div", "entropy"), .quant = c("read.count", "umi.count", "read.prop",
  "umi.prop"), .q = 5, .norm = F, .do.norm = NA, .laplace = 0)
}
\arguments{
\item{.data}{Cloneset or a list of clonesets.}

\item{.method}{Which method to use for the diversity estimation. See "Details" for methods.}

\item{.quant}{Which column to use for the quantity of clonotypes: "read.count" for the "Read.count" column, 
"umi.count" for the "Umi.count" column, "read.prop" for the "Read.proportion" column, "umi.prop" for 
the "Umi.proportion" column.}

\item{.q}{q-parameter for the Diversity index.}

\item{.norm}{If T than compute the normsalised entropy.}

\item{.do.norm}{One of the three values - NA, T or F. If NA than check for distrubution (sum(.data) == 1)
and normalise it with the given laplace correction value if needed. if T then do normalisation and laplace
correction. If F than don't do normalisaton and laplace correction.}

\item{.laplace}{Value for Laplace correction.}
}
\description{
General interface to all cloneset diversity functions.
}
\details{
You can see a more detailed description for each diversity method at \link{diversity}.

Parameter \code{.method} can have one of the following value each corresponding to the specific method:

- "div" for the true diversity, or the effective number of types (basic function \code{diversity}).

- "inv.simp" for the inverse Simpson index (basic function \code{inverse.simpson}).

- "gini" for the Gini coefficient (basic function \code{gini}).

- "gini.simp" for the Gini-Simpson index (basic function \code{gini.simpson}).

- "chao1" for the Chao1 estimator (basic function \code{chao1}).

- "entropy" for the Shannon entropy measure (basic function \code{entropy}).
}
\examples{
\dontrun{
data(twb)
twb.div <- repDiversity(twb, "chao1", "read.count")
}
}
\seealso{
\link{diversity}, \link{entropy}
}

