% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{read.names.sql}
\alias{read.names.sql}
\title{Read NCBI names file}
\usage{
read.names.sql(nameFile, sqlFile = "nameNode.sqlite",
  overwrite = FALSE)
}
\arguments{
\item{nameFile}{string giving the path to an NCBI name file to read from (both gzipped or uncompressed files are ok)}

\item{sqlFile}{a string giving the path where the output SQLite file should be saved}

\item{overwrite}{If TRUE, delete names table in database if present and regenerate}
}
\value{
invisibly returns a string with path to sqlfile
}
\description{
Take an NCBI names file, keep only scientific names and convert it to a SQLite table
}
\examples{
namesText<-c(
  "1\\t|\\tall\\t|\\t\\t|\\tsynonym\\t|",
  "1\\t|\\troot\\t|\\t\\t|\\tscientific name\\t|",
  "2\\t|\\tBacteria\\t|\\tBacteria <prokaryotes>\\t|\\tscientific name\\t|",
  "2\\t|\\tMonera\\t|\\tMonera <Bacteria>\\t|\\tin-part\\t|",
  "2\\t|\\tProcaryotae\\t|\\tProcaryotae <Bacteria>\\t|\\tin-part\\t|"
)
tmpFile<-tempfile()
writeLines(namesText,tmpFile)
read.names.sql(tmpFile)
}
\references{
\url{ftp://ftp.ncbi.nih.gov/pub/taxonomy/}
}
\seealso{
\code{\link{read.nodes}}
}
