% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_methods.R
\name{dedupe}
\alias{dedupe}
\title{Remove duplicate scientific names in a taxonomy}
\usage{
dedupe(x, ranked = TRUE)
}
\arguments{
\item{x}{A tibble created with \code{load_taxonomies()} or \code{load_population()} or \code{load_sample()}.}

\item{ranked}{A logical indicating whether duplicates should be removed by certainty
of taxonomic status. Defaults to \code{TRUE}.}
}
\value{
A de-duplicated tibble
}
\description{
Remove duplicate scientific names in a taxonomy
}
\details{
This method can be used in one of two ways. By simply passing a tibble as input,
duplicates will be stringently removed based on the following order: "accepted", "synonym","homotypic synonym",
"heterotypic synonym", "proparte synonym","doubtful", NA. If however the ranked parameter is set to \code{FALSE},
duplicates will only be removed based on the scientific names, but not on taxonomic status, which results
in less duplicates being removed.
}
\examples{
dedupe(load_sample())
}
