% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_methods.R
\name{download_ncbi}
\alias{download_ncbi}
\title{Download the NCBI taxonomy}
\usage{
download_ncbi(taxonkitpath = NA)
}
\arguments{
\item{taxonkitpath}{A string containing the full path to where \code{Taxonkit} is installed (optional).}
}
\value{
A character vector containing paths to the relevant downloaded and unzipped NCBI data dump files, or
if the \code{taxonkitpath} parameter was set, the path to \code{All.lineages.tsv}.
}
\description{
Download the NCBI taxonomy
}
\details{
This method downloads a NCBI taxonomy archive file to a temporary directory,
extracts four files (\code{nodes.dmp}, \code{names.dmp}, \code{merged.dmp} and \code{deleted.dmp})
from the downloaded archive file, and then removes the archive file. If the path
to a \code{Taxonkit} installation is supplied, \code{Taxonkit} is called and the location of
the four files is passed to \code{Taxonkit} as an argument. Output is saved in the same
temporary folder in a file called \code{All.lineages.tsv}.
}
\examples{
\dontrun{download_ncbi()}
\dontrun{download_ncbi(taxonkitpath = "/home/usr/bin/taxonkit")}
}
