% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset}
\alias{subset}
\alias{subset,taxlist-method}
\title{Subset method for taxlist objects}
\usage{
\S4method{subset}{taxlist}(
  x,
  subset,
  slot = "names",
  keep_children = FALSE,
  keep_parents = FALSE,
  ...
)
}
\arguments{
\item{x}{Object of class \linkS4class{taxlist}.}

\item{subset}{Logical vector or logical operation to apply as subset.}

\item{slot}{Character value indicating the slot to be used for the subset.}

\item{keep_children}{Logical value applied to hierarchical structures.}

\item{keep_parents}{Logical value applied to hierarchical structures.}

\item{...}{Further arguments to be passed to or from other methods.}
}
\value{
An object of class \linkS4class{taxlist}.
}
\description{
Subset of \linkS4class{taxlist} objects will be done applying either
logical operations or pattern matchings.
Subsets can be referred to information contained either in the slot
\code{taxonNames}, \code{taxonRelations} or \code{taxonTraits}.
}
\details{
The argument \code{subset} will be applied to the slot specified in argument
\code{slot}.
This argument also allows partial matchings.

Arguments \code{keep_children} and \code{keep_parents} are applied to objects
including parent-child relationships.
When those arguments are set as \code{FALSE} (the default), children or parents
of selected taxon concepts will not be included in the subset.

Be aware that \code{\link[=subset]{subset()}} won't work properly inside of function definitions.
}
\examples{
## Produce a data set with only reed plants
sp_list <- subset(x = Easplist, subset = life_form == "reed_plant",
    slot = "taxonTraits", keep_parents = TRUE)
sp_list

summary(as.factor(sp_list$life_form))
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
