% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/col_search.R
\name{col_search}
\alias{col_search}
\title{Search Catalogue of Life for taxonomic IDs}
\usage{
col_search(name = NULL, id = NULL, start = NULL, checklist = NULL,
  response = "terse", ...)
}
\arguments{
\item{name}{The string to search for. Only exact matches found the name given
   will be returned, unless one or wildcards are included in the search
   string. An * (asterisk) character denotes a wildcard; a % (percentage)
character may also be used. The name must be at least 3 characters long,
not counting wildcard characters.}

\item{id}{The record ID of the specific record to return (only for scientific
names of species or infraspecific taxa)}

\item{start}{The first record to return. If omitted, the results are returned
from the first record (start=0). This is useful if the total number of
results is larger than the maximum number of results returned by a single
Web service query (currently the maximum number of results returned by a
single query is 500 for terse queries and 50 for full queries).}

\item{checklist}{The year of the checklist to query, if you want a specific
year's checklist instead of the lastest as default (numeric).}

\item{response}{(character) one of "terse" or "full"}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A list of data.frame's.
}
\description{
Search Catalogue of Life for taxonomic IDs
}
\details{
You must provide one of name or id. The other parameters (format
		and start) are optional.
}
\examples{
\dontrun{
# A basic example
col_search(name="Apis")
col_search(name="Agapostemon")
col_search(name="Poa")

# Get full response, i.e., more data
col_search(name="Apis", response="full")
col_search(name="Poa", response="full")

# Many names
col_search(name=c("Apis","Puma concolor"))
col_search(name=c("Apis","Puma concolor"), response = "full")

# An example where there is no data
col_search(id = "36c623ad9e3da39c2e978fa3576ad415")
col_search(id = "36c623ad9e3da39c2e978fa3576ad415", response = "full")
col_search(id = "787ce23969f5188c2467126d9a545be1")
col_search(id = "787ce23969f5188c2467126d9a545be1", response = "full")
col_search(id = c("36c623ad9e3da39c2e978fa3576ad415", "787ce23969f5188c2467126d9a545be1"))
## a synonym
col_search(id = "f726bdaa5924cabf8581f99889de51fc")
col_search(id = "f726bdaa5924cabf8581f99889de51fc", response = "full")
}
}
\references{
\url{http://webservice.catalogueoflife.org/}
}

