% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{data}
\name{db_ref}
\alias{db_ref}
\title{Valid taxonomy databases}
\format{
An object of class \code{list} of length 3.
}
\usage{
db_ref
}
\description{
This defines the valid taxonomic databases that can be used in \link{taxon_db}
objects and objects that use \link{taxon_db} objects, such as \link{taxon_id} and
\link{taxon}. \code{db_ref$get} can be used to see information for the databases. Users
can add their own custom databases to the list using \code{db_ref$set}. For each
database the following information is included:
\itemize{
\item The URL for the website associated with the database
\item A short description
\item The regular expression that defines valid taxon IDs
\item The ranks used in the database if specified
}
}
\section{Attribution}{


This code is based on the code handling options in \link{knitr}.
}

\examples{

# List all database definitions
db_ref$get()

# Get a specific database definition
db_ref$get('ncbi')

# Add or overwrite a database definition
db_ref$set(
  name = "my_new_database",
  url = "http://www.my_tax_database.com",
  desc = "I just made this up",
  id_regex = ".*"
)

# Reset definitions to default values
db_ref$reset()

}
\keyword{datasets}
