% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{names_used}
\alias{names_used}
\title{Get names of data used in expressions}
\arguments{
\item{obj}{a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object}

\item{...}{One or more expressions}
}
\value{
Named \code{character}
}
\description{
Get names of available data used in expressions. This is used to find data
for use with \href{http://adv-r.had.co.nz/Computing-on-the-language.html}{non-standard evaluation} (NSE) in
functions like \code{\link[=filter_taxa]{filter_taxa()}}. Expressions are not evaluated and do not need
to make sense.
\preformatted{
obj$names_used(...)}
}
\examples{
ex_taxmap$names_used(n_legs + dangerous == invalid_expression)

}
\seealso{
Other NSE helpers: 
\code{\link{all_names}()},
\code{\link{data_used}},
\code{\link{get_data}()}
}
\concept{NSE helpers}
\keyword{internal}
