% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazyhelpers.R
\name{filtering-helpers}
\alias{filtering-helpers}
\alias{ranks}
\alias{nms}
\alias{ids}
\title{Taxonomic filtering helpers}
\usage{
ranks(...)

nms(...)

ids(...)
}
\arguments{
\item{...}{quoted rank names, taxonomic names, taxonomic ids, or
any of those with supported operators (See \strong{Supported Relational
Operators} below)}
}
\description{
Taxonomic filtering helpers
}
\note{
NSE is not supported at the moment, but may be in the future
}
\section{How do these functions work?}{

Each function assigns some metadata so we can more easily process
your query downstream. In addition, we check for whether you've
used any relational operators and pull those out to make downstream
processing easier

The goal of these functions is to make it easy to combine queries
based on each of rank names, taxonomic names, and taxonomic ids.

These are designed to be used inside of \code{\link[=pop]{pop()}}, \code{\link[=pick]{pick()}}, \code{\link[=span]{span()}}. Inside
of those functions, we figure out what rank names you want to filter
on, then check against a reference dataset (\link{ranks_ref}) to allow
ordered queries like \emph{I want all taxa between Class and Genus}. If you
provide rank names, we just use those, then do the filtering you requested.
If you provide taxonomic names or ids we figure out what rank names you are
referring to, then we can proceed as in the previous sentence.
}

\section{Supported Relational Operators}{

\itemize{
\item \code{>} all items above rank of x
\item \code{>=} all items above rank of x, inclusive
\item \code{<} all items below rank of x
\item \code{<=} all items below rank of x, inclusive
}
}

\section{ranks}{

Ranks can be any character string in the set of acceptable rank
names.
}

\section{nms}{

\code{nms} is named to avoid using \code{names} which would collide with the
fxn \code{\link[base:names]{base::names()}} in Base R. Can pass in any character taxonomic names.
}

\section{ids}{

Ids are any alphanumeric taxonomic identifier. Some database providers
use all digits, but some use a combination of digits and characters.
}

\examples{
ranks("genus")
ranks("order", "genus")
ranks("> genus")

nms("Poaceae")
nms("Poaceae", "Poa")
nms("< Poaceae")

ids(4544)
ids(4544, 4479)
ids("< 4479")
}
