% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--docs.R
\name{mutate_obs}
\alias{mutate_obs}
\title{Add columns to \code{\link[=taxmap]{taxmap()}} objects}
\arguments{
\item{obj}{An object of type \code{\link[=taxmap]{taxmap()}}}

\item{target}{The name of the table in \code{obj$data} to filter}

\item{...}{One or more named columns to add. Newly created columns can be
referenced in the same function call. Any variable name that appears in
\code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own.}
}
\value{
An object of type \code{\link[=taxmap]{taxmap()}}
}
\description{
Add columns to tables in \code{obj$data} in \code{\link[=taxmap]{taxmap()}} objects.  See \code{\link[dplyr:mutate]{dplyr::mutate()}} for the inspiration for
this function and more information. Calling the function using the
\code{obj$mutate_obs(...)} style edits "obj" in place, unlike most R
functions. However, calling the function using the \code{mutate_obs(obj, ...)} imitates R's traditional copy-on-modify semantics, so "obj" would not be
changed; instead a changed version would be returned, like most R functions.
\preformatted{
obj$mutate_obs(target, ...)
mutate_obs(obj, target, ...)}
}
\examples{
mutate_obs(ex_taxmap, "info",
           new_col = "Im new",
           newer_col = paste0(new_col, "er!"))

}
\seealso{
Other taxmap manipulation functions: \code{\link{arrange_obs}},
  \code{\link{arrange_taxa}}, \code{\link{filter_obs}},
  \code{\link{filter_taxa}}, \code{\link{sample_frac_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{transmute_obs}}
}
