% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-rmd.R
\name{rmd}
\alias{rmd}
\alias{rmd.default}
\alias{rmd.cell}
\alias{rmd.cell_n}
\alias{rmd.tangram}
\title{Generate an Rmd table entry from a cell object}
\usage{
rmd(object, key = FALSE, ...)

\method{rmd}{default}(object, key = FALSE, ...)

\method{rmd}{cell}(object, key = FALSE, ...)

\method{rmd}{cell_n}(object, key = FALSE, ...)

\method{rmd}{tangram}(object, key = NULL, append = FALSE, pad = 10, ...)
}
\arguments{
\item{object}{The cell_fstat for indexing}

\item{key}{A filename to write key values into. Can be false if no key file is desired.}

\item{...}{additional arguments to renderer. Unused}

\item{append}{logical; Should the key file be appended too, or overwritten}

\item{pad}{numeric; Minimum width of columns can be a single or vector of numerics.}
}
\value{
A string representation of the table
}
\description{
Given a cell object generate the corresponding piece of an Rmd table
}
\examples{
 rmd(tangram(drug ~ bili, pbc))
}
