% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile-operators.R
\name{table_builder}
\alias{table_builder}
\alias{col_header}
\alias{row_header}
\alias{write_cell}
\alias{home}
\alias{cursor_up}
\alias{cursor_down}
\alias{cursor_left}
\alias{cursor_right}
\alias{cursor_pos}
\alias{carriage_return}
\alias{line_feed}
\alias{new_line}
\alias{new_row}
\alias{new_col}
\alias{table_builder_apply}
\alias{add_col}
\alias{add_row}
\title{Table Construction Toolset}
\usage{
table_builder(row = NA, column = NA, embedded = FALSE)

col_header(table_builder, ..., sub = TRUE)

row_header(table_builder, ..., sub = TRUE)

write_cell(table_builder, x, ...)

home(table_builder)

cursor_up(table_builder, n = 1)

cursor_down(table_builder, n = 1)

cursor_left(table_builder, n = 1)

cursor_right(table_builder, n = 1)

cursor_pos(table_builder, nrow, ncol)

carriage_return(table_builder)

line_feed(table_builder, n = 1)

new_line(table_builder)

new_row(table_builder)

new_col(table_builder)

table_builder_apply(table_builder, X, FUN, ...)

add_col(table_builder, ...)

add_row(table_builder, ...)
}
\arguments{
\item{row}{character; Value to use for indexing}

\item{column}{character; Value to use for indexing}

\item{embedded}{logical; is this to be embedded in another table}

\item{table_builder}{The table builder object to modify}

\item{...}{object; the elements to add or additional values to pass to FUN}

\item{sub}{logical; treat as subheader if after first header, defaults to TRUE}

\item{x}{any; a value to use for a cell in operation}

\item{n}{integer; Number of positions to move cursor, defaults to 1}

\item{nrow}{integer; specifies desired row}

\item{ncol}{integer; specifies desired col}

\item{X}{list or vector; items to iterate over}

\item{FUN}{the function to use in iteration}
}
\value{
the modified table_builder
}
\description{
These functions help build a table. A table can be embedded
inside another table as a cell as well. The typical transform functions
that provide bundles of functionality utilize this approach and each
row column pair are rendered as a cell that is a table and later the
whole table is flattened.
}
\details{
This library is designed to use a core \code{table_builder} object that
is passed from function to function using the pipe \code{\%>\%} operator.
First create a \code{table_builder} using the \code{table_builder()} function and
use the operators to build out the table. The row and column given to
the \code{table_builder} are what is used in later construction of an
index key. The table_builder object contains an item table which
is the current table being built.

Column and row headers are attached as attributes to each table
constructed are are tables in their own right that should match
the proper dimension of the contained table. When later flattening
a table of embedded tables, only the left and top most headers are
used.

The table builder also has a cursor which maintains the state
of where cell items are being written in table construction. It
is possible to move the cursor into undefined portions of the table.
Therefore it is best to use cursor movement to move in defined
rows or columns of information.
}
\examples{
library(magrittr)
table_builder()                        \%>\%
col_header("One","Two","Three","Four") \%>\%
row_header("A",   "B",   "C")          \%>\%
write_cell("A1")                       \%>\%
cursor_right()                         \%>\%
add_col("A2", "A3")                    \%>\%
home()                                 \%>\%
new_line()                             \%>\%
table_builder_apply(1:3, FUN=function(tb, x) {
  tb \%>\% write_cell(paste0("B",x)) \%>\% cursor_right()
})                                     \%>\%
new_col()                              \%>\%
add_row(paste0(c("A","B","C"), 4))     \%>\%
cursor_up(2)                           \%>\%
line_feed()                            \%>\%
cursor_left(3)                         \%>\%
add_col(paste0("C", 1:4))
}
