% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile-cell.R
\name{cell.htest}
\alias{cell.htest}
\title{Construct hypothesis test cell}
\usage{
\method{cell}{htest}(x, format = 2, pformat = "\%1.3f", reference = NULL,
  ...)
}
\arguments{
\item{x}{The htest object to convert to a rendereable cell}

\item{format}{numeric or character; A formatting directive applied to statistics}

\item{pformat}{numeric or character; A formatting directive to be applied to p-values}

\item{reference}{numeric or character; A reference indicator for this test}

\item{...}{additional specifiers for identifying this cell (see key)}
}
\value{
an S3 rendereable cell that is a hypothesis test
}
\description{
Construct a cell from a hypothesis test
}
\details{
Currently handles cor.test, t.test and chisq.test objects
}
\examples{
cell(cor.test(rnorm(10), rnorm(10), method="spearman"))
cell(cor.test(rnorm(10), rnorm(10)))
cell(chisq.test(rpois(10,1)))
cell(t.test(rnorm(10), rnorm(10)))
}
