% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_row.R
\name{binary_row}
\alias{binary_row}
\title{Binary Row}
\usage{
binary_row(
  list_obj,
  row_var,
  col_var = NULL,
  newdata = FALSE,
  rowlabels = NULL,
  summary = binary_default,
  reference = NULL,
  missing = NULL,
  overall = NULL,
  comparison = NULL,
  digits = 2,
  indent = 5
)
}
\arguments{
\item{list_obj}{the name of the tbl_start object previously initialized.}

\item{row_var}{the name of the variable to be used in the rows.}

\item{col_var}{the variable to be used in the table columns. Default is from initialized tbl_start object.}

\item{newdata}{enter new dataset name if different from that initialized in tbl_start.}

\item{rowlabels}{the label for the table row name, if different from row_var.}

\item{summary}{summary function for the data. Default will compute proportion (N).}

\item{reference}{the name of the row category to use as the reference. Default will use alphabetical first category.}

\item{missing}{logical: if TRUE, missing data is considered; FALSE only uses complete cases.}

\item{overall}{logical: if TRUE, an overall column is included.}

\item{comparison}{the name of the comparison test to use, if different from that initialized in tbl_start.}

\item{digits}{significant digits to use.}

\item{indent}{number of spaces to indent category names.}
}
\value{
A list with the binary row's table information added as a new element to \code{list_obj}.
}
\description{
Adds in a binary row to the table.
}
\examples{
iris$color <- sample(c("Blue", "Purple"), size=150, replace=TRUE)
x <- tbl_start(iris, "Species", missing=TRUE, overall=TRUE, comparison=TRUE) \%>\%
  binary_row("color", rowlabels="Color")
}
\keyword{tangram.pipe}
