% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_helpers.R
\name{trajectories}
\alias{trajectories}
\title{Timing pattern frequency within clusters}
\usage{
trajectories(
  clustering,
  only = NULL,
  clusters = NULL,
  additional_data = NULL,
  ...
)
}
\arguments{
\item{only}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{object} and/or \code{additional_data}.

The default \code{NULL} selects all clusterings in \code{object}.}

\item{clusters}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> An unquoted
expression naming the cluster or clusters in \code{object} one wants to
see summaries of. Names can be used as if they were positions in the data
frame, so expressions like I:IV can be used to select a range of clusters.

The default \code{NULL} selects all clusters in the chosen clusterings of
\code{object}.}

\item{additional_data}{A data frame with additional data that may be
(left-)joined onto the \code{parameters} in \code{object}. This is often
used in conjuction with \code{only} to select specific clusterings based on
\code{additional_data}.}

\item{...}{Additional arguments passed to the internal summary function.
\itemize{
\item \code{cluster_wise}  an option in the \code{medications()} function.
\item \code{m} an option in the \code{medications()} function. A numeric restricting the
number of distinct ATC codes plotted within each cluster. That is, the
(at most) \code{m} most frequent ATC codes within that cluster is given a
color.
\item \code{q} an option in the \code{medications()} function. A numeric between 0 and 1
restricting the minimal ATC codes frequency displayed within each
cluster.
\item \code{count_grouper} an option in the \code{amounts()} function. A function for
grouping counts. As a standard it groups counts as 1 medication, 2
medications, and 3+ medications.
\item \code{atc_groups} A data.frame specifying the ATC groups to summaries by. The
data.frame must have two columns: (1) \code{regex} giving regular expressions
specifying the wanted ATC groups and (2) \code{atc_groups} the name of this
ATC grouping. As a standard the anatomical level (first level) of the ATC
codes is used.
}}
}
\value{
\code{trajectories()} returns a list of class \code{summary.medic.trajectories} with
two data frames:
\subsection{average}{
\itemize{
\item \code{cluster_name} the name of the clustering.
\item \code{cluster} the \code{cluster} name.
\item \emph{timing variables} the average timing value in \code{cluster}.
\item \code{n} the number of people in \code{cluster}.
}
}

\subsection{individual}{
\itemize{
\item \code{cluster_name} the name of the clustering.
\item \code{cluster} the cluster name.
\item \emph{timing variables} a unique timing pattern in \code{cluster}.
\item \code{n} number of people with this unique timing pattern.
}
}
}
\description{
\code{trajectories()} calculates the average timing paths within clusters.
}
\details{
\code{trajectories()} calculates both the number of unique timing trajectories in
each cluster and the average timing trajectories in each cluster.
}
\keyword{internal}
