% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_tailplot.R
\name{gamma_tailplot}
\alias{gamma_tailplot}
\title{Plot the estimated g and the corresponding confidence intervals}
\usage{
gamma_tailplot(
  x,
  method = c("unbiased", "bootstrap", "jackknife"),
  R = 1000,
  conf.level = 0.95,
  ci.points = 101,
  xscale = "o"
)
}
\arguments{
\item{x}{a vector containing the sample data.}

\item{method}{the method used for computing the confidence intervals (options include unbiased variance estimator, jackknife, and bootstrap).}

\item{R}{the number of the bootstrap replicates.}

\item{conf.level}{the confidence level for the interval.}

\item{ci.points}{the number of thresholds used in the calculation of the confidence intervals.}

\item{xscale}{the scale of the x-axis (options include "o" = original, "l" = log scale, "b" = both).}
}
\value{
A plot showing the estimated \eqn{g(d)} versus threshold \eqn{d}, optionally on a logarithmic x-axis and including confidence intervals.
}
\description{
This function produces a tail plot for the estimate \eqn{\hat{g}} over a range of thresholds for a given sample, including confidence intervals computed by one of three methods (unbiased, bootstrap or jackknife). The function also allows a choice between original and log scale.
}
\details{
For more details about the estimator \eqn{\hat{g}} and the computation of the confidence intervals see \link{gamma_tail}.
}
\examples{
\donttest{
x <- rgamma(2e2, 0.5, 0.2)
gamma_tailplot(x, method="unbiased", xscale="o")
}

}
\references{
Iwashita, T. & Klar, B. (2024). A gamma tail statistic and its asymptotics. Statistica Neerlandica 78:2, 264-280.
\doi{https://doi.org/10.1111/stan.12316}
}
