% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_themes.R
\name{theme_readthedown}
\alias{theme_readthedown}
\alias{theme_tadaa}
\title{ggplot2 theme to fit the readthedown Rmd format}
\usage{
theme_readthedown(
  base_size = 12,
  base_family = "",
  bg = "#fcfcfc",
  axis_emph = "xy",
  ...
)

theme_tadaa(
  base_size = 12,
  base_family = "",
  bg = "#fcfcfc",
  axis_emph = "xy",
  ...
)
}
\arguments{
\item{base_size}{Base text size, defaults to \code{12}.}

\item{base_family}{Base text family. Use \code{"Roboto Slab"} to match the \code{readthedown}
headers, or \code{"Lato"} for the body style.}

\item{bg}{Background color, defaults to \code{rmdformats::readthedown}'s background,
\verb{#fcfcfc}}

\item{axis_emph}{Which axis to emphasize visually (black lines). One of \verb{"x", "y", "xy", NULL}.}

\item{...}{Other arguments passed to \code{\link[ggplot2:theme]{ggplot2::theme()}}}
}
\value{
A ggplot2 theme
}
\description{
A ggplot theme to fit \code{rmdformats::readthedown} in terms of background color and
dark grid lines.
}
\examples{
\dontrun{
library(ggplot2)
p <- ggplot(ngo, aes(x = stunzahl)) +
  geom_bar()

p + theme_readthedown()
p + theme_readthedown(base_family = "Lato")
p + theme_readthedown(base_family = "Roboto Condensed", axis_emph = "x")
}
}
