% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel.ci.R
\name{prepanel.ci}
\alias{prepanel.ci}
\title{Prepanel for ciplot}
\usage{
prepanel.ci(x, y, lower, upper, subscripts, groups = NULL, ...)
}
\arguments{
\item{x, y}{x and y values, numeric or factor}

\item{lower}{lower confidence limits}

\item{upper}{upper confidence limits}

\item{groups, subscripts}{ See \code{\link[lattice]{xyplot}}.  Whenever
    appropriate, calculations are done separately for each group and
    then combined.  }

\item{...}{ other arguments, usually ignored }
}
\description{
Prepanel for ciplot
}
\examples{
mod <- lm(Petal.Width ~ Petal.Length * Species, data = iris)
newdat <- expand.grid(
  Petal.Length = seq(1, 7, by = 0.1),
  Species = c("setosa", "versicolor", "virginica")
)
pred <- predict(mod, newdat, interval = "confidence")
dd <- cbind(newdat, pred)

xyplot(
  fit ~ Petal.Length,
  groups = Species, data = dd,
  prepanel = prepanel.ci,
  ylab = "Petal Width",
  xlab = "Petal Length",
  lower = dd$lwr, upper = dd$upr, alpha = 0.3,
  panel = function(...) {
    panel.ci(..., grid = TRUE)
    panel.xyplot(type = "l", ...)
  }
)

}
