% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyplot.lm.R
\name{xyplot.lm}
\alias{xyplot.lm}
\title{Lattice plot diagnostics for lm objects}
\usage{
\method{xyplot}{lm}(x, data = NULL, which = c(1:3, 5), main = FALSE,
  id.n = 3, labels.id = names(residuals(x)), cex.id = 0.75,
  cook.levels = c(0.5, 1), label.pos = c(4, 2), layout = NULL, ...)
}
\arguments{
\item{x}{\code{lm} object, typically result of \code{\link{lm}} or
    \code{\link{glm}}.}

\item{data}{Only provided for method consistency and is ignored.}

\item{which}{if a subset of the plots is required, specify a subset of the
numbers \code{1:6}}

\item{main}{if \code{TRUE} plots default titles. Can also be a \code{list} or character
vector of length 6.}

\item{id.n}{number of points to be labelled in each plot, starting
    with the most extreme.}

\item{labels.id}{vector of labels, from which the labels for extreme
    points will be chosen.  \code{NULL} uses observation numbers.}

\item{cex.id}{magnification of point labels.}

\item{cook.levels}{levels of Cook's distance at which to draw contours.}

\item{label.pos}{positioning of labels, for the left half and right
    half of the graph respectively, for plots 1-3.}

\item{layout}{a numeric vector with \code{[columns, rows]} to use in the call
to \code{\link[gridExtra:grid.arrange]{gridExtra::grid.arrange()}}, or a layout matrix which will then be
passed as the \code{layout_matrix} in \code{grid.arrange()}.}

\item{\dots}{arguments to be passed to \code{\link[lattice:xyplot]{lattice::xyplot()}}.}
}
\value{
A list of \code{trellis} objects or a single \code{trellis} object.
}
\description{
Lattice plot diagnostics for \code{lm} objects, mostly mimicking the behavior
of \code{\link[stats:plot.lm]{stats::plot.lm()}} but based on \code{\link[lattice:xyplot]{lattice::xyplot()}} instead.
}
\examples{
fit <- lm(Sepal.Length ~ Sepal.Width, data = iris)
xyplot(fit)
xyplot(fit, which = 5)
}
\seealso{
\code{\link[stats:lm]{stats::lm()}}, \code{\link[stats:plot.lm]{stats::plot.lm()}}, \code{\link[lattice:xyplot]{lattice::xyplot()}}
}
\author{
Original by John Maindonald and Martin Maechler. Adaptation to
lattice by Johan Larsson.
}
