% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab_core}
\alias{tab_core}
\title{Plain single cross-table}
\usage{
tab_core(
  data,
  row_var,
  col_var,
  ...,
  wt,
  digits = 0,
  subtext = "",
  is_grouped = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{row_var, col_var}{The row variable, which will be printed with one level per line,
and the column variable, which will be printed with one level per column.
For numeric variables means are calculated, in a single column.}

\item{...}{Tab variables : a subtable is made for each combination of levels of the
selected variables. Leave empty to make a simple cross-table. All tab variables
are converted to factor.}

\item{wt}{A weight variable, of class numeric. Leave empty for unweighted results.}

\item{digits}{The number of digits to print, as a single integer.}

\item{subtext}{A character vector to print rows of legend under the table.}

\item{is_grouped}{Set to \code{TRUE} if the data is already grouped. For internal
use in \code{\link{tab_many}} only, since repeating grouping operations reduce
performance.}
}
\value{
A \code{tibble} of class \code{tabxplor_tab}. If \code{...} (\code{tab_vars})
are provided, a \code{tab} of class \code{tabxplor_grouped_tab}.
All non-text columns are \code{\link{fmt}} vectors of class \code{tabxplor_fmt},
storing all the data necessary to print formats and colors. Columns with \code{row_var}
and \code{tab_vars} are of class \code{factor} : every added \code{factor} will be
considered as a \code{tab_vars} and used for grouping. To add text columns without
using them in calculations, be sure they are of class \code{character}.
}
\description{
Plain single cross-table
}
\examples{
# A typical workflow with tabxplor step-by-step functions :
\donttest{
data <- dplyr::starwars \%>\% tab_prepare(sex, hair_color)

data \%>\%
  tab_core(sex, hair_color) \%>\%
  tab_tot()  \%>\%
  tab_chi2() \%>\%
  tab_pct()  \%>\%
  tab_ci(color = "after_ci")
}
}
