% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale-deg}
\alias{scale-deg}
\alias{scale_degree}
\alias{scale_note}
\alias{note_in_scale}
\title{Scale degrees and mappings}
\usage{
scale_degree(notes, key = "c", scale = "diatonic",
  naturalize = FALSE, roman = FALSE, ...)

scale_note(deg, key = "c", scale = "diatonic", collapse = FALSE, ...)

note_in_scale(notes, key = "c", scale = "diatonic", ...)
}
\arguments{
\item{notes}{character, a string of notes.}

\item{key}{character, key signature (or root note) for scale, depending on
the type of \code{scale}.}

\item{scale}{character, the suffix of a supported \code{scale_*} function.}

\item{naturalize}{logical, whether to naturalize any sharps or flats before
obtaiuning the scale degree.}

\item{roman}{logical, return integer scale degrees as Roman numerals.}

\item{...}{additional arguments passed to the scale function, e.g.,
\code{sharp = FALSE} for \code{scale_chromatic}.}

\item{deg}{integer, roman class, or character roman, the scale degree.}

\item{collapse}{logical, collapse result into a single string ready for
phrase construction.}
}
\value{
integer, or roman class if \code{roman = TRUE} for
\code{scale_degree}. character for \code{scale_note}.
}
\description{
These functions assist with mapping between scale degrees, notes and chords.
}
\details{
Obtain the scale degree of a note in a supported scale with
\code{scale_degree}.
This function also works with chords inside noteworthy strings.
It only considers the first note in each space-delimited entry.
\code{notes} may be a vector of single entries (non-delimited).
Notes return \code{NA} if not explicitly in the scale.
This includes cases where the note is in the scale but is notated as sharp
or flat when the \code{scale} and/or \code{key} provide the opposite.

The inverse of \code{scale_degree} is \code{scale_note}, for obtaining the
note associated with a scale degree.
This could be done simply by calling a \code{scale_*} function and indexing
its output directly, but this wrapper is provided to complement
\code{scale_degree}.
Additionally, it accepts the common Roman numeral input for the degree.
This can be with the \code{roman} class or as a character string.
Degrees return \code{NA} if outside the scale degree range.

\code{note_in_scale} performs a vectorized logical check if each note is in
a given scale.
This function strictly accepts single notes in noteworthy strings.
To check if chords are diatonic to the scale,
see \code{\link{chord_is_diatonic}}. To check generally if a
\code{noteworthy} string is fully diatonic, see \code{\link{is_diatonic}}.
}
\examples{
scale_degree("c e g")
scale_degree("c e g", roman = TRUE)
scale_degree("c e g", key = "d")
scale_degree("c, e_3 g' f#ac#")
scale_degree("c, e_3 g' f#ac#", naturalize = TRUE)
scale_degree("c, e_3 g' f#ac#", scale = "chromatic")
scale_degree("c, e_3 g' f#ac#", scale = "chromatic", sharp = FALSE)

scale_note(1:3)
scale_note(c(1, 3, 8), "d", collapse = TRUE)
all(sapply(list(4, "IV", as.roman(4)), scale_note) == "f")
}
\seealso{
\code{\link{scale-helpers}}
}
