% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modes.R
\name{mode-helpers}
\alias{mode-helpers}
\alias{modes}
\alias{is_mode}
\alias{mode_rotate}
\alias{mode_modern}
\alias{mode_ionian}
\alias{mode_dorian}
\alias{mode_phrygian}
\alias{mode_lydian}
\alias{mode_mixolydian}
\alias{mode_aeolian}
\alias{mode_locrian}
\title{Mode helpers}
\usage{
modes(mode = c("all", "major", "minor"))

is_mode(notes, ignore_octave = FALSE)

mode_rotate(notes, n = 0, ignore_octave = FALSE)

mode_modern(mode = "ionian", key = "c", collapse = FALSE,
  ignore_octave = FALSE)

mode_ionian(key = "c", collapse = FALSE, ignore_octave = FALSE)

mode_dorian(key = "c", collapse = FALSE, ignore_octave = FALSE)

mode_phrygian(key = "c", collapse = FALSE, ignore_octave = FALSE)

mode_lydian(key = "c", collapse = FALSE, ignore_octave = FALSE)

mode_mixolydian(key = "c", collapse = FALSE, ignore_octave = FALSE)

mode_aeolian(key = "c", collapse = FALSE, ignore_octave = FALSE)

mode_locrian(key = "c", collapse = FALSE, ignore_octave = FALSE)
}
\arguments{
\item{mode}{character, which mode.}

\item{notes}{character, for mode, may be a noteworthy string of seven notes,
space- or vector-delimited.}

\item{ignore_octave}{logical, strip octave numbering from modes not rooted
on C.}

\item{n}{integer, degree of rotation.}

\item{key}{character, key signature.}

\item{collapse}{logical, collapse result into a single string ready for
phrase construction.}
}
\value{
character
}
\description{
Helper functions for working with musical modes.
}
\details{
For valid key signatures, see \code{\link{keys}}.

Modern modes based on major scales are available by key signature using the
\code{mode_*} functions. The seven modes can be listed with \code{modes}.
Noteworthy strings of proper length can be checked to match against a mode
with \code{is_mode}.
Modes can be rotated with \code{mode_rotate}, a wrapper around
\code{note_rotate}.
}
\examples{
modes()
mode_dorian("c")
mode_modern("dorian", "c")
mode_modern("dorian", "c", ignore_octave = TRUE)

identical(mode_rotate(mode_ionian("c"), 1), mode_dorian("d"))
identical(
  mode_rotate(mode_ionian("c", ignore_octave = TRUE), 1),
  mode_dorian("d", ignore_octave = TRUE)
)

x <- sapply(modes(), mode_modern, ignore_octave = TRUE)
setNames(data.frame(t(x)), as.roman(1:7))
}
\seealso{
\code{\link{keys}}, \code{\link{scale-helpers}}
}
