% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{append_phrases}
\alias{append_phrases}
\alias{glue}
\alias{dup}
\title{Append and duplicate}
\usage{
glue(...)

dup(x, n = 1)
}
\arguments{
\item{...}{character, phrase or non-phrase string.}

\item{x}{character, phrase or non-phrase string.}

\item{n}{integer, number of repetitions.}
}
\value{
phrase on non-phrase character string, noteworthy string if applicable.
}
\description{
Helper functions for appending or pasting musical phrases and other strings together as well as repetition.
The functions \code{glue} and \code{dup} are based on base functions \code{paste} and\code{rep}, respectively, but are tailored for efficiency in creating musical phrases.
}
\details{
These functions respect and retain the phrase class when applied to phrases. They are aggressive for phrases and secondarily for noteworthy strings.
Combining a phrase with a non-phrase string will assume compatibility and result in a new phrase object.
If no phrase objects are present, the presence of any noteworthy string will in turn attempt to force conversion of all strings to noteworthy strings.
The aggressiveness provides convenience, but is counter to expected coercion rules. It is up to the user to ensure all inputs can be forced into the more specific child class.

This is especially useful for repeated instances. This function applies to general slur notation as well.
Multiple input formats are allowed. Total number of note durations must be even because all slurs require start and stop points.
}
\examples{
glue(8, "16-", "8^")
dup(1, 2)
x <- phrase("c ec'g' ec'g'", "4 4 2", "5 432 432")
y <- phrase("a", 1, 5)
glue(x, y)
glue(x, dup(y, 2))
glue(x, "r1") # add a simple rest instance
class(glue(x, y))
class(dup(y, 2))
class(glue(x, "r1"))
class(dup("r1", 2))
class(glue("r1", "r4"))
}
