% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tablet.R
\name{splice.data.frame}
\alias{splice.data.frame}
\title{Splice A Data Frame}
\usage{
\method{splice}{data.frame}(x, all = "All", ...)
}
\arguments{
\item{x}{data.frame}

\item{all}{a column name for ungrouped statistics; can have length zero to suppress ungrouped column}

\item{...}{passed to \code{\link{tablet}}}
}
\value{
tablet
}
\description{
Splices a data.frame.  If the data.frame has groups, tablet() is
called for each group in succession, only the last of which requests
'all'.  The results are column-bound, and duplicate columns
are removed.
}
\examples{
library(boot)
library(dplyr)
library(magrittr)
melanoma \%>\%
  select(-time, -year) \%>\%
  mutate(sex = factor(sex), ulcer = factor(ulcer)) \%>\%
  mutate(status2 = ifelse(status == 2, 2, 4)) \%>\%
  group_by(status, status2) \%>\%
  splice
}
\keyword{internal}
