% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_styles.R
\name{tbl_styles}
\alias{tbl_styles}
\title{tbl_styles}
\usage{
tbl_styles(
  background_style = openxlsx::createStyle(fgFill = "#ffffff"),
  hline_style = openxlsx::createStyle(border = "Top", borderColour =
    openxlsx::openxlsx_getOp("borderColour", "black"), borderStyle =
    openxlsx::openxlsx_getOp("borderStyle", "double")),
  vline_style = openxlsx::createStyle(border = "Left", borderColour =
    openxlsx::openxlsx_getOp("borderColour", "black"), borderStyle =
    openxlsx::openxlsx_getOp("borderStyle", "double")),
  title_style = openxlsx::createStyle(fontSize = 14, halign = "left", textDecoration =
    "bold"),
  subtitle_style = openxlsx::createStyle(fontSize = 11, halign = "left", textDecoration =
    "bold"),
  header_style = openxlsx::createStyle(fontSize = 11, halign = "center", border =
    "BottomLeftRight", borderColour = openxlsx::openxlsx_getOp("borderColour", "black"),
    borderStyle = openxlsx::openxlsx_getOp("borderStyle", "double"), textDecoration =
    "bold"),
  merge_rownames = TRUE,
  merged_rownames_style = createStyle(valign = "top"),
  footnote_style = openxlsx::createStyle(fontSize = 11, halign = "left"),
  data_styles = create_data_styles(),
  cell_styles = NULL
)
}
\arguments{
\item{background_style}{color etc. for the entire background of the table}

\item{hline_style}{style for the horizontal lines used in the table. Note:
the style for the lines under spanners is defined in the title_style.}

\item{vline_style}{style for the vertical lines used in the table. Note:
the style for the lines under spanners is defined in the title_style.}

\item{title_style}{style applied to the table title}

\item{subtitle_style}{style applied to the table subtitle}

\item{header_style}{style applied to the table header (column names)}

\item{merge_rownames}{boolean: Should adjacent rows with identical names be merged?}

\item{merged_rownames_style}{style applied to the merged rownames}

\item{footnote_style}{style applied to the table footnote}

\item{data_styles}{styles applied to the columns in the data set based on their
classes (e.g., numeric, character, etc.). data_styles must be a list of lists.
Each inner list must have two elements: a "test" that is used to determine the
class of a data colum (e.g., is.double) and a style that is then applied to
the columns where the test returns TRUE. Note that styles will be applied in the
order of the list, meaning that a later style may overwrite an earlier style.}

\item{cell_styles}{an optional list with styles for selected cells in the
data frame.}
}
\value{
a list with styles for different elements of the table
}
\description{
Define styles for different elements of the table.
}
\examples{
tbl_styles()
}
