% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabledown.R
\docType{package}
\name{tabledown}
\alias{tabledown}
\title{Produce Publication Quality Tables and Plots}
\description{
The tabledown package provides necessary data frames used throughout the book and some neat functions.
}
\section{tabledown Data-frames}{

\enumerate{
\item Rotter: Psychometric validation data of Bangla Rotter's Internal- External Scale.
\item Gantt and Spot: Two sample data-frames for creating project management Gantt chart.
\item FFMQ.CFA: Structural Validation data of Bangla Five Factor Mindfulness Questionnaire.
\item FFMQ.Val:Correlational Validity evidences of Bangla Five Factor Mindfulness Questionnaire.
}
}

\section{tabledown functions}{

This packages includes some neat and useful functions to create tables and figures suitable for journal submission:
\enumerate{
\item fac.tab(): Creates a publication ready table from the output of "psych"  package based factor analysis.
\item des.tab(): Creates a publication ready descriptive table of Item analysis with the reporting of normality assumptions.
\item normality.loop(): Compute normality test on the whole data frame. No grouping variable required.
\item bedTime(): Calculate total time spent in bed from the sleep log entry.
\item cfa.tab():Creates a table with necessary fit indices from a "lavaan" class objects.
\item cfa.tab/multi():creates a table with necessary fit indices from several lavaan class objects.
\item ggicc: Creates a ggplot2 based publication ready Item Characteristics Curve from the "mirt" package based item response theory estimations.
\item ggiteminfo: Creates a ggplot2 based publication ready Item Information Curve from the "mirt" package based item response theory estimations.
\item ggtestinfo: Creates a ggplot2 based publication ready Test Information Curve from the "mirt" package based item response theory estimations.
\item ggtestinfo_se: Creates a ggplot2 based publication ready Test Information Curve with standard error from the "mirt" package based item response theory estimations.
It is advisable that you load \strong{tidyverse} along with \strong{tabledown}
}
}

