% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_glue.R
\name{table_glue}
\alias{table_glue}
\title{Expressive rounding for table values}
\usage{
table_glue(..., rspec = NULL, .sep = "", .envir = parent.frame())
}
\arguments{
\item{...}{strings to round and format. Multiple inputs are concatenated
together. Named arguments are \strong{not} supported.}

\item{rspec}{a \code{rounding_specification} object. If no \code{rspec}
is given, a default setting will round values to decimal places
based on the magnitude of the values.}

\item{.sep}{Separator used to separate elements}

\item{.envir}{environment to evaluate each expression in.}
}
\value{
a character vector of length equal to the vectors supplied in \code{...}
}
\description{
Expressive rounding for table values
}
\examples{

x <- runif(10)
y <- runif(10)

table_glue("{x} / {y} = {x/y}")

table_glue("{x}", "({100 * y}\%)", .sep = ' ')

df = data.frame(x = 1:10, y=1:10)

table_glue("{x} / {y} = {as.integer(x/y)}", .envir = df)
table_glue("{x} / {y} = {as.integer(x/y)}")

with(df, table_glue("{x} / {y} = {as.integer(x/y)}"))

mtcars$car <- rownames(mtcars)
# use the default rounding specification
table_glue(
  "the {car} gets ~{mpg} miles/gallon and weighs ~{wt} thousand lbs",
  .envir = mtcars[1:3, ]
)

# use your own rounding specification
rspec <- round_spec()
rspec <- round_using_decimal(rspec, digits = 1)

table_glue(
  "the {car} gets ~{mpg} miles/gallon and weighs ~{wt} thousand lbs",
  rspec = rspec,
  .envir = mtcars[1:3, ]
)
}
\seealso{
Other table helpers: 
\code{\link{table_ester}()},
\code{\link{table_pvalue}()},
\code{\link{table_value}()}
}
\concept{table helpers}
