% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{safe_max}
\alias{safe_max}
\title{Calculate \code{max} but suppress the warning when all values are missing}
\usage{
safe_max(x, na.rm = FALSE)
}
\arguments{
\item{x}{A numerical vector.}

\item{na.rm}{A boolean indicating whether to remove NAs.}
}
\value{
The max of \code{x} or NA when values are missing.
}
\description{
This function is a drop-in replacement for \code{max}, which is used in
\code{cat_summarise}. It suppresses the warning when all values are NA and
na.rm is TRUE, and returns NA instead of -Inf.
}
\keyword{internal}
