% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.show.people.R
\name{trakt.show.people}
\alias{trakt.show.people}
\title{Get the cast and crew of a show}
\usage{
trakt.show.people(target, extended = "min")
}
\arguments{
\item{target}{The \code{slug} of the show requested, e.g. \code{game-of-thrones}}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}}
}
\value{
A \code{list} containing people info
}
\description{
\code{trakt.show.people} pulls show people data.
}
\details{
Returns all cast and crew for a show.
}
\note{
See \href{http://docs.trakt.apiary.io/#reference/shows/people/get-all-people-for-a-show}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad.people <- trakt.show.people("breaking-bad")
}
}

