% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google.R
\name{font_families_google}
\alias{font_families_google}
\alias{font.families.google}
\title{List Font Families Available in Google Fonts}
\usage{
font_families_google(db_cache = TRUE, handle = curl::new_handle())

font.families.google()
}
\arguments{
\item{db_cache}{whether to obtain font metadata from a cache site. Using cache
is typically faster, but not as update-to-date as using the official
API. If \code{db_cache} is set to \code{FALSE}, then metadata
are retrieved from the Google Fonts API.}

\item{handle}{a curl handle object passed to \code{curl::curl_download()} and
\code{curl::curl_fetch_memory()}.}
}
\value{
A character vector of available font family names in Google Fonts.
}
\description{
The two versions of this function are equivalent, but the
"underscore" naming is preferred.

This function lists family names of the fonts that are currently
available in Google Fonts. When running this function for the first time, 
it may take a few seconds to fetch the font information database.
This function requires the \pkg{jsonlite} and \pkg{curl} packages.
}
\examples{
\dontrun{
font_families_google()
}

}
\seealso{
\code{\link{font_add_google}()}
}
\author{
Yixuan Qiu <\url{https://statr.me/}>
}
