% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_accuracy.R
\name{get_accuracy}
\alias{get_accuracy}
\title{get_accuracy}
\usage{
get_accuracy(data, correct, apps = NULL)
}
\arguments{
\item{data}{A dataframe}

\item{correct}{A string indicating the column name storing if the symptom checker solved the case (TRUE or FALSE)}

\item{apps}{A string indicating the column name storing the app names (optional)}
}
\value{
A data frame object containing the accuracy of the symptom checker or the accuracy of multiple symptom checkers. Use the apps argument to calculate this metric for multiple symptom checkers.
}
\description{
Calculates the accuracy of one or multiple symptom checkers
}
\examples{
data(symptomcheckRdata)
accuracy <- get_accuracy(
  data = symptomcheckRdata,
  correct = "Correct_Triage_Advice_provided_from_app",
  apps = "App_name"
  )
}
