% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_comprehensiveness.R
\name{get_comprehensiveness}
\alias{get_comprehensiveness}
\title{get_comprehensiveness}
\usage{
get_comprehensiveness(
  data,
  triagelevel_advice,
  vector_not_entered,
  apps = NULL
)
}
\arguments{
\item{data}{A dataframe}

\item{triagelevel_advice}{A string indicating the column name storing the recommendation of a symptom checker for a case}

\item{vector_not_entered}{A vector indicating the values in which missing values are coded (e.g., as NA or a specified value such as -99)}

\item{apps}{A string indicating the column name storing the app names}
}
\value{
A list containing both a raw number and the percentage of comprehensiveness for one or multiple symptom checkers
}
\description{
Calculates the comprehensiveness for one or multiple symptom checkers
}
\examples{
data(symptomcheckRdata)
comprehensiveness <- get_comprehensiveness(
  data = symptomcheckRdata,
  triagelevel_advice = "Triage_advice_from_app",
  vector_not_entered = c(NA),
  apps = "App_name"
  )

}
