% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_correct.R
\docType{methods}
\name{correct.hyph}
\alias{correct.hyph}
\alias{correct.hyph,kRp.hyphen-method}
\alias{correct.hyph}
\title{Correct kRp.hyphen objects}
\usage{
correct.hyph(obj, word = NULL, hyphen = NULL, cache = TRUE)

\S4method{correct.hyph}{kRp.hyphen}(obj, word = NULL, hyphen = NULL,
  cache = TRUE)
}
\arguments{
\item{obj}{An object of class \code{\link[sylly]{kRp.hyphen-class}}.}

\item{word}{A character string,
      the (possibly incorrectly hyphenated) \code{word} entry to be replaced with \code{hyphen}.}

\item{hyphen}{A character string,
      the new manually hyphenated version of \code{word}. Mustn't contain
anything other than characters of \code{word} plus the hyphenation mark \code{"-"}.}

\item{cache}{Logical, if \code{TRUE},
      the given hyphenation will be added to the sessions' hyphenation cache.
Existing entries for the same word will be replaced.}
}
\value{
An object of the same class as \code{obj}.
}
\description{
The method \code{correct.hyph} can be used to alter objects of class \code{\link[sylly]{kRp.hyphen-class}}.
}
\details{
Although hyphenation should turn out to be rather accurate,
      the algorithm does ususally produce
some errors. If you want to correct for these flaws, this method can be of help,
      because it might prevent you from
introducing new errors. That is,
      it will do some sanitiy checks before the object is actually manipulated and returned.

That is,
      \code{correct.hyph} checks whether \code{word} and \code{hyphen} are actually hyphenations of the
same token before proceeding. If so,
      it will also recalculate the number of syllables and update the \code{syll}
field.

If both \code{word} and \code{hyphen} are \code{NULL},
      \code{correct.hyph} will try to simply recalculate the syllable count
for each word,
      by counting the hyphenation marks (and adding 1 to the number). This can be usefull if you changed hyphenation
some other way, e.g. in a spreadsheet GUI,
      but don't want to have to correct the syllable count yourself as well.
}
\examples{
\dontrun{
hyphenated.txt <- correct.hyph(hyphenated.txt, "Hilfe", "Hil-fe")
}
}
\keyword{methods}
