% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocManifest.R
\name{BiocSVNManifest}
\alias{BiocSVNManifest}
\title{Create a manifest of Bioc SVN locations}
\usage{
BiocSVNManifest(bioc_vers = "devel", software_only = TRUE)
}
\arguments{
\item{bioc_vers}{A version number for a bioc release, or \code{"devel"} to
for the current devel trunk}

\item{software_only}{logical. Should only software packages be
included in the manifest? Defaults to TRUE}
}
\value{
A PkgManifest which contains SVN locations for all
packages found in the specified bioc repositories, as well
as those listed in \code{not_in_repo}
}
\description{
Create a manifest of Bioc SVN locations
}
\details{
In combination with the \code{lazyRepo} function, this
manifest can be used to work from a local, working checkout of a
set of inter-dependent Bioconductor packages.
}
\examples{
## wrapped in try because it fails on some finnicky build systems
bman = try(BiocSVNManifest())
bman
\dontrun{
repo = lazyRepo("rtracklayer", bman)
}
}
\seealso{
\code{\link{lazyRepo}}
}

