% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/destination.R
\name{destination}
\alias{destination}
\title{Destination on Sphere or Ellipsoid}
\usage{
destination(lat, lon, brng, distance, units = "nm", ellipsoid = datum(),
  radius = convert.distance(6371, "km", "nm"), type = c("ellipsoid",
  "sphere", "vincenty"))
}
\arguments{
\item{lat,lon}{numeric. The latitude and longitude of the coordinate in decimal degrees.}

\item{brng}{numeric. The bearing, ranging from 0 to 360 degrees.}

\item{distance}{numeric. The distance travelled, in units specified by \code{units}.}

\item{units}{units of \code{distance}. Can be "km" (kilometers), "nm" (nautical miles),
or "mi" (statute miles).}

\item{ellipsoid}{ellipsoid model parameters as returned from a call to \code{\link{datum}}.}

\item{radius}{numeric. Define the radius for \code{type} = "sphere". In units of \code{units}.}

\item{type}{Character defining type of surface. Can be "sphere", "ellipsoid", "Vincenty", or
partial match thereof (case-insensitive).}
}
\value{
latitude and longitude of destination.
}
\description{
Calculates latitude and longitude of the destination along a sphere or ellipsoid.
}
\examples{
destination(32.87, -117.25, 262, 4174, units = "km", type = "sphere")
destination(32.87, -117.25, 262, 4174, units = "km", type = "ellipsoid")
destination(32.87, -117.25, 262, 4174, units = "km", type = "vincenty")
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Ellipsoid code adapted from JavaScript by Larry Bogan
\url{http://adsabs.harvard.edu/full/2000JRASC..94...48B}.\cr
Vincenty code adapted from JavaScript by Chris Veness
\url{http://www.movable-type.co.uk/scripts/latlong-vincenty-direct.html}
Vincenty, T. 1975.  Direct and inverse solutions of geodesics on the ellipsoid with
application of nested equations. Survey Review 22(176):88-93
\url{http://www.ngs.noaa.gov/PUBS_LIB/inverse.pdf}.
}

