% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/das_read.R
\name{das_read}
\alias{das_read}
\title{Read DAS file(s)}
\usage{
das_read(file, skip = 0, tz = "UTC", ...)
}
\arguments{
\item{file}{filename(s) of one or more DAS files}

\item{skip}{integer; see \code{\link[readr]{read_fwf}}. Default is 0}

\item{tz}{character; see \link[base]{strptime}. Default is "UTC"}

\item{...}{ignored}
}
\value{
A \code{das_dfr} object, which is also a data frame, with DAS data read into columns.
  The data are read into the data frame as characters as described in 'Details',
  with the following exceptions:
  \tabular{lll}{
    \emph{Name} \tab \emph{Class} \tab \emph{Details}\cr
    EffortDot \tab logical   \tab \code{TRUE} if "." was present, and \code{FALSE} otherwise\cr
    DateTime  \tab POSIXct   \tab combination of 'Date' and 'Time' columns with time zone \code{tz}\cr
    Lat       \tab numeric   \tab 'Latitude' column converted to decimal degrees in range [-90, 90]\cr
    Lon       \tab numeric   \tab 'Longitude' column converted to decimal degrees in range [-180, 180]\cr
    Data#     \tab character \tab leading/trailing whitespace trimmed for non-comment events (i.e. where 'Event' is not "C")\cr
    EventNum  \tab character \tab leading/trailing whitespace trimmed; left as character for some project-specific codes\cr
    file_das  \tab character \tab base filename, extracted from the \code{file} argument\cr
    line_num  \tab integer   \tab line number of each data row\cr
  }

  Warnings are printed if any unexpected events have \code{NA} DateTime/Lat/Lon values,
  or if any Lat/Lon values cannot be converted to numeric values.
  Events that are 'expected' to have \code{NA} DateTime/Lat/Lon values are:
  C, ?, 1, 2, 3, 4, 5, 6, 7, 8
}
\description{
Read one or more fixed-width DAS text file(s) generated by WinCruz into a data frame,
  where each line is data for a specific event
}
\details{
Reads/parses DAS data into columns of a data frame.
  If \code{file} contains multiple filenames, then the individual
  data frames will be concatenated.

  The provided DAS file must adhere to the following column number and format specifications:
  \tabular{lrr}{
    \emph{Item}  \tab \emph{Columns} \tab \emph{Format}\cr
    Event number \tab 1-3   \tab \cr
    Event        \tab 4     \tab \cr
    Effort dot   \tab 5     \tab \cr
    Time         \tab 6-11  \tab HHMMSS or HHMM\cr
    Date         \tab 13-18 \tab MMDDYY\cr
    Latitude     \tab 20-28 \tab NDD:MM.MM\cr
    Longitude    \tab 30-39 \tab WDDD:MM.MM\cr
    Data1        \tab 40-44 \tab \cr
    Data2        \tab 45-49 \tab \cr
    Data3        \tab 50-54 \tab \cr
    Data4        \tab 55-59 \tab \cr
    Data5        \tab 60-64 \tab \cr
    Data6        \tab 65-69 \tab \cr
    Data7        \tab 70-74 \tab \cr
    Data8        \tab 75-79 \tab \cr
    Data9        \tab 80-84 \tab \cr
    Data10       \tab 85-89 \tab \cr
    Data11       \tab 90-94 \tab \cr
    Data12       \tab 95+   \tab \cr
  }

  See \code{\link{das_format_pdf}} for more information about DAS format requirements, and
  note that 'Data#' columns may be referred to as 'Field#' columns in other documentation.
}
\examples{
y <- system.file("das_sample.das", package = "swfscDAS")
das_read(y)

}
