% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/oin.R
\name{as.oin}
\alias{as.oin}
\title{Parse organizational identity numbers}
\usage{
as.oin(oin)
}
\arguments{
\item{oin}{Vector with swedish organizational identity numbers in character format. See details.}
}
\value{
Character vector (of class \code{oin}) with swedish organizational identity numbers.
}
\description{
Parse organizational identity numbers
}
\details{
Check and convert a vector of organizational identity numbers.
The following format is accepted:
\itemize{
  \item character: \code{GNNNNN-NNNC}
}
}
\examples{
ex_oin <- c("556000-4615", "232100-0156", "802002-4280", "8020024280", "AA2002-4280")
as.oin(ex_oin)
}
\references{
\href{http://www.skatteverket.se/download/18.70ac421612e2a997f85800040284/1359707510840/70909.pdf}{SKV 709}
}

