% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_definition.R
\name{pick_threshold}
\alias{pick_threshold}
\title{Pick a Threshold for the Events' Definition}
\usage{
pick_threshold(data_distr, var, threshold = NA)
}
\arguments{
\item{data_distr}{A numeric vector to pick a threshold for. In the package's
pipeline it is the timeseries of polarization and average speed of a group.}

\item{var}{A string, the of the distribution to use at the interactive step
to ask the user for input.}

\item{threshold}{If NA (the default), the function runs in interactive mode
and the user inputs a given value to return. If numeric, the function just
returns this input (interactive case is off).}
}
\value{
the selected or input value of the user for the lower threshold, of
 the variable to be used for the definition of an event.
}
\description{
An interactive function that calculates and prints the quantiles
 of the input distribution and asks the user to input the threshold value
 they want to keep. If a threshold is given as input, then the function
 checks that the threshold type is correct and returns it. In the swaRmverse
 framework, the timesteps with lower values than the threshold will be
 labelled as not part of an event.
}
\examples{
d <- rnorm(25, sd = 1)
d_variable_name <- "a variable"
the_threshold <- 0
pick_threshold(d, d_variable_name, threshold = the_threshold)

## If the threshold is not known, run the interactive version
## without giving a threshold as input.
}
\seealso{
\code{\link{define_events}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
