% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_pos.R
\name{add_rel_pos_coords}
\alias{add_rel_pos_coords}
\title{Relative Position Coordinates}
\usage{
add_rel_pos_coords(data, focal_heading = c(0, 1))
}
\arguments{
\item{data}{Dataframe with the bearing angle and
distance of each individual to specific neighbors.
Column names must include: bangl, nnd.}

\item{focal_heading}{The heading of the focal individual,
default = c(0,1) for plotting neighbor heading north.}
}
\value{
The input dataframe with additional \code{nnx} (nearest neighbor x coordinate)
 and \code{nny} (nearest neighbor y coordinate) columns.
}
\description{
This function calculates the x and y coordinates of a neighbor
in the reference frame of the focal individual.
}
\examples{

data <- data.frame(
bangl = runif(25, 0, pi),
nnd = runif(25)
)
data <- add_rel_pos_coords(data)

}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
