% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inlineSVG.R
\name{xmlSVG}
\alias{xmlSVG}
\title{Run plotting code and return svg}
\usage{
xmlSVG(code, ..., standalone = FALSE, height = 7, width = 7)
}
\arguments{
\item{code}{Plotting code to execute.}

\item{...}{Other arguments passed on to \code{\link{svglite}}.}

\item{standalone}{Produce a standalone svg file? If \code{FALSE}, omits
xml header and default namespace.}

\item{height}{Height and width in inches.}

\item{width}{Height and width in inches.}
}
\value{
A \code{xml2::xml_document} object.
}
\description{
This is useful primarily for testing. Requires the \code{xml2} package.
}
\examples{
if (require("xml2")) {
  x <- xmlSVG(plot(1, axes = FALSE))
  x
  xml_find_all(x, ".//text")
}
}

