% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_after_boot.R
\name{ba.boot}
\alias{ba.boot}
\title{Bootstrap after Bootstrap}
\usage{
ba.boot(x, nc = 1)
}
\arguments{
\item{x}{SVAR object of class "sboot"}

\item{nc}{Integer. Number of processor cores}
}
\value{
A list of class "sboot" with elements
\item{true}{Point estimate of impulse response functions}
\item{bootstrap}{List of length "nboot" holding bootstrap impulse response functions}
\item{SE}{Bootstrapped standard errors of estimated covariance decomposition
(only if "x" has method "Cramer von-Mises", or "Distance covariances")}
\item{nboot}{Number of bootstrap iterations}
\item{b_length}{Length of each block}
\item{point_estimate}{Point estimate of covariance decomposition}
\item{boot_mean}{Mean of bootstrapped covariance decompositions}
\item{signrest}{Evaluated sign pattern}
\item{sign_complete}{Frequency of appearance of the complete sign pattern in all bootstrapped covariance decompositions}
\item{sign_part}{Frequency of bootstrapped covariance decompositions which conform the complete predetermined sign pattern. If signrest=NULL,
 the frequency of bootstrapped covariance decompositions that hold the same sign pattern as the point estimate is provided.}
\item{sign_part}{Frequency of single shocks in all bootstrapped covariance decompositions which accord to a specific predetermined sign pattern}
\item{cov_bs}{Covariance matrix of bootstrapped parameter in impact relations matrix}
\item{method}{Used bootstrap method}
\item{VAR}{Estimated input VAR object}
}
\description{
Bootstrap intervals based on bias-adjusted estimators
}
\examples{
\donttest{
# data contains quarterly observations from 1965Q1 to 2008Q3
# x = output gap
# pi = inflation
# i = interest rates
set.seed(23211)
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.dc(v1)
summary(x1)

# Bootstrap
bb <- mb.boot(x1, b.length = 15, nboot = 300, n.ahead = 30, nc = 1, signrest = NULL)
summary(bb)
plot(bb, lowerq = 0.16, upperq = 0.84)

# Bias-adjusted bootstrap
bb2 <- ba.boot(bb, nc = 1)
plot(bb2, lowerq = 0.16, upperq = 0.84)
}

}
\references{
Kilian, L. (1998). Small-sample confidence intervals for impulse response functions. Review of Economics and Statistics 80, 218-230.
}
\seealso{
\code{\link{mb.boot}}, \code{\link{wild.boot}}
}
