% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obj_browse.R
\name{obj_browse}
\alias{obj_browse}
\alias{obj_clear}
\alias{obj_dir}
\alias{obj_info}
\alias{obj_list}
\alias{write.objList}
\alias{print.objList}
\alias{obj_search}
\alias{obj_menu}
\alias{objBrowse}
\alias{objClear}
\alias{objDir}
\alias{objInfo}
\alias{objList}
\alias{objSearch}
\alias{objMenu}
\title{Functions to implement an object browser}
\usage{
obj_browse(id = "default", envir = .GlobalEnv, all.names = NULL,
  pattern = NULL, group = NULL, sep = "\\t", path = NULL,
  regenerate = FALSE)

obj_clear(id = "default")

obj_dir()

obj_info(id = "default", envir = .GlobalEnv, object = "", path = NULL)

obj_list(id = "default", envir = .GlobalEnv, object = NULL,
  all.names = FALSE, pattern = "", group = "", all.info = FALSE,
  sep = "\\t", path = NULL, compare = TRUE, ...)

write.objList(x, path, sep = "\\t", ...)

\method{print}{objList}(x, sep = NA, eol = "\\n", header = !attr(x,
  "all.info"), raw.output = !is.na(sep), ...)

obj_search(sep = "\\t", path = NULL, compare = TRUE)

obj_menu(id = "default", envir = .GlobalEnv, objects = "", sep = "\\t",
  path = NULL)

objBrowse(id = "default", envir = .GlobalEnv, all.names = NULL,
  pattern = NULL, group = NULL, sep = "\\t", path = NULL,
  regenerate = FALSE)

objClear(id = "default")

objDir()

objInfo(id = "default", envir = .GlobalEnv, object = "", path = NULL)

objList(id = "default", envir = .GlobalEnv, object = NULL,
  all.names = FALSE, pattern = "", group = "", all.info = FALSE,
  sep = "\\t", path = NULL, compare = TRUE, ...)

objSearch(sep = "\\t", path = NULL, compare = TRUE)

objMenu(id = "default", envir = .GlobalEnv, objects = "", sep = "\\t",
  path = NULL)
}
\arguments{
\item{id}{The id of the object browser (you can run several ones
concurrently, providing you give them different ids).}

\item{envir}{An environment, or the name of the environment, or the position
in the \code{\link[=search]{search()}} path.}

\item{all.names}{Do we display all names (including hidden variables starting
with '.')?}

\item{pattern}{A pattern to match for selecting variables.}

\item{group}{A group to filter.}

\item{sep}{Separator to use between items (if path is not \code{NULL}).}

\item{path}{The path where to write a temporary file with the requested
information. Set to NULL (default) if you don't pass this data to your GUI
client by mean of a file.}

\item{regenerate}{Do we force to regenerate the information?}

\item{object}{Name of the object selected in the object browser,
components/arguments of which should be listed.}

\item{all.info}{Do we return all the information (envir as first column or
not (by default).}

\item{compare}{If TRUE, result is compared with last cached value and the
client is updated only if something changed.}

\item{...}{Further arguments, passed to \code{\link[=write.table]{write.table()}}.}

\item{x}{Object returned by \code{obj_list()}.}

\item{eol}{Separator to use between object entries, default is to list each
item in a separate line.}

\item{header}{If \code{TRUE}, two-line header is printed, of the form: \cr
Environment = environment name \cr
Object = object name \cr
Default is not to print header if \code{all.info == TRUE}.}

\item{raw.output}{If \code{TRUE}, a compact, better suited for parsing output is
produced.}

\item{objects}{A list with selected items in the object browser.}
}
\value{
Depending on the function, a list, a string, a reference to an
external, temporary file or \code{TRUE} in case of success or \code{FALSE} otherwise
is returned invisibly.
}
\description{
These functions provide features required to implement a
complete object browser in a GUI client.
}
\details{
\code{obj_browse()} does the horsework. \code{obj_dir()} gets the temporary
directory where exchange files with the GUI client are stored, in case you
exchange data through files. You can use a better way to communicate with
your GUI (you have to provide your code) and disable writing to files by
using \code{path = NULL}.

\code{obj_list()} lists objects in a given environment, elements of a recursive
object or function argument.

\code{obj_search()} lists the search path.

\code{obj_clear()} clears any reference to a given object browser.

\code{obj_info()} computes a tooltip info for a given object.

obj_menu()` computes a context menu for selected object(s) in the object
explorer managed by the GUI client.

\code{print.objList()} print method for \code{objList} objects.
}
\examples{
# Create various context menus
data(iris)
(obj_info(object = "iris"))
data(trees)
# For one object
(obj_menu(objects = "iris"))
# For multiple objects
(obj_menu(objects = c("iris", "trees")))
# For inexistant object (return "")
(obj_info(object = "noobject"))
(obj_menu(objects = "noobject"))
rm(iris, trees)

# For environments
(obj_info(envir = ".GlobalEnv"))
(obj_menu(envir = ".GlobalEnv"))
(obj_info(envir = "SciViews:TempEnv"))
(obj_menu(envir = "SciViews:TempEnv"))
(obj_info(envir = "package:datasets"))
(obj_menu(envir = "package:datasets"))
# For an environment that does not exist on the search path (return "")
(obj_info(envir = "noenvir"))
(obj_menu(envir = "noenvir"))
}
\seealso{
\code{\link[=completion]{completion()}}, \code{\link[=call_tip]{call_tip()}}
}
\author{
Philippe Grosjean \href{mailto:phgrosjean@sciviews.org}{phgrosjean@sciviews.org} &
Kamil Barton \href{mailto:kamil.barton@uni-wuerzburg.de}{kamil.barton@uni-wuerzburg.de}
}
\concept{
graphical user interface (GUI), object explorer
}
\keyword{misc}
