% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setUI.R
\name{setUI}
\alias{setUI}
\alias{setUI.gui}
\alias{startUI}
\alias{startUI.gui}
\title{Set a property in the UI (User Interface), or start an action.}
\usage{
setUI(..., gui = .GUI)

\method{setUI}{gui}(fun, call, args, res, widgets, status, msg = NULL, ...,
  gui = .GUI)

startUI(..., gui = .GUI)

\method{startUI}{gui}(fun, call, default, widgets = NULL,
  status = "busy-modal", msg = "Displaying a modal dialog box",
  msg.no.ask = "A modal dialog box was by-passed", ..., gui = .GUI)
}
\arguments{
\item{...}{Any other property of the GUI, provided as named arguments.}

\item{gui}{A \code{gui} object.}

\item{fun}{The name of the calling function. Only required if \code{call} is
provided.}

\item{call}{The call in the generic as obtained by \code{match.call()}.}

\item{args}{A list with checked and/or reworked arguments for a method. The
generic can do this work, so that code does not need to be duplicated in
all its methods.}

\item{res}{Any data returned by the GUI (the results).}

\item{widgets}{The class name of the current widgets implementation.}

\item{status}{Description of the current GUI status. Could be "ok", "busy",
"busy-modal" (a modal dialog box is currently displayed), "by-passed" (the
GUI was by-passed because \code{dont_ask()} returns \code{TRUE}), "error",
or any other status indicator suitable for the current state of your GUI.}

\item{msg}{The message expliciting the status. Cannot be provided without
status.}

\item{default}{The default value to return if the UI is by-passed because in
non interactive mode, or ask is \code{FALSE}.}

\item{msg.no.ask}{The message expliciting the status in case the UI is
by-passed.}
}
\description{
Using \code{setUI()} is the preferred way to set a property in a \code{gui} object.
Similarly, \code{startUI()} should be used to indicate that an UI action requiring
user input is initiated (say, a modal input or file selection dialog box).
}
\section{Methods (by class)}{
\itemize{
\item \code{gui}: Set an UI property for a \code{gui} object.

\item \code{gui}: Start an UI for a \code{gui} object.
}}

\examples{
# Imagine you implement a new input box
# In your function, you have this code:
myInput <- function(default = "an answer", gui = .GUI) {

  # Start a GUI action... or by-pass it!
  if (gui$startUI("myInput", call = match.call(), default = default,
    msg = "Displaying an input dialog box",
    msg.no.ask = "An input dialog box was by-passed")) {

    # Here the input dialog box is displayed and R waits for user feedback
    # ... [your code here]
    res <- "some results" # Imagine this is the text typed in the box

    # When the input dialog box is closed, the function should do:
    setUI(res = res, status = NULL)
  }
  invisible(gui)
}
}
\seealso{
\code{\link[=gui_add]{gui_add()}}, \code{\link[=$.gui]{$.gui()}}
}
\concept{
GUI API implementation
}
\keyword{misc}
