% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_cutpoint.R
\name{surv_cutpoint}
\alias{surv_cutpoint}
\alias{surv_categorize}
\alias{summary.surv_cutpoint}
\alias{print.surv_cutpoint}
\alias{plot.surv_cutpoint}
\alias{print.plot_surv_cutpoint}
\title{Determine the Optimal Cutpoint for Continuous Variables}
\usage{
surv_cutpoint(data, time = "time", event = "event", variables,
  minprop = 0.1, progressbar = TRUE)

surv_categorize(x, variables = NULL, labels = c("low", "high"))

\method{summary}{surv_cutpoint}(object, ...)

\method{print}{surv_cutpoint}(x, ...)

\method{plot}{surv_cutpoint}(x, variables = NULL,
  ggtheme = theme_classic(), bins = 30, ...)

\method{print}{plot_surv_cutpoint}(x, ..., newpage = TRUE)
}
\arguments{
\item{data}{a data frame containing survival information (time, event) and
continuous variables (e.g.: gene expression data).}

\item{time, event}{column names containing time and event data, respectively.
Event values sould be 0 or 1.}

\item{variables}{a character vector containing the names of variables of
interest, for wich we want to estimate the optimal cutpoint.}

\item{minprop}{the minimal proportion of observations per group.}

\item{progressbar}{logical value. If TRUE, show progress bar. Progressbar is
shown only, when the number of variables > 5.}

\item{x, object}{an object of class surv_cutpoint}

\item{labels}{labels for the levels of the resulting category.}

\item{...}{other arguments. For plots, see ?ggpubr::ggpar}

\item{ggtheme}{function, ggplot2 theme name. Default value is
\link{theme_classic}. Allowed values include ggplot2 official themes. see
?ggplot2::ggtheme.}

\item{bins}{Number of bins for histogram. Defaults to 30.}

\item{newpage}{open a new page. See \code{\link{grid.arrange}}.}
}
\value{
\itemize{

 \item{ \bold{surv_cutpoint()}: returns an object of class 'surv_cutpoint',
 which is a list with the following components: \itemize{ \item maxstat
 results for each variable (see ?maxstat::maxstat) \item cutpoint: a data
 frame containing the optimal cutpoint of each variable. Rows are variable
 names and columns are c("cutpoint", "statistic"). \item data: a data frame
 containing the survival data and the original data for the specified
 variables. \item minprop: the minimal proportion of observations per group.
 \item not_numeric: contains data for non-numeric variables, in the context
 where the user provided categorical variable names in the argument
 variables.} } Methods defined for surv_cutpoint object are summary, print
 and plot.

 \item \bold{surv_categorize()}: returns an object of class
 'surv_categorize', which is a data frame containing the survival data and
 the categorized variables.

 }
}
\description{
Determine the optimal cutpoint for one or multiple continuous
 variables at once, using the maximally selected rank statistics from the
 'maxstat' R package. This is an outcome-oriented  methods  providing  a
 value of a cutpoint that correspond to the most significant relation with
 outcome (here, survival).
 \itemize{
 \item \code{surv_cutpoint()}: Determine the optimal cutpoint for each variable using 'maxstat'.
 \item \code{surv_categorize()}: Divide each variable values based on the cutpoint returned by \code{surv_cutpoint()}.
 }
}
\examples{
# 0. Load some data
data(myeloma)
head(myeloma)

# 1. Determine the optimal cutpoint of variables
res.cut <- surv_cutpoint(myeloma, time = "time", event = "event",
   variables = c("DEPDC1", "WHSC1", "CRIM1"))

summary(res.cut)

# 2. Plot cutpoint for DEPDC1
# palette = "npg" (nature publishing group), see ?ggpubr::ggpar
plot(res.cut, "DEPDC1", palette = "npg")

# 3. Categorize variables
res.cat <- surv_categorize(res.cut)
head(res.cat)

# 4. Fit survival curves and visualize
library("survival")
fit <- survfit(Surv(time, event) ~DEPDC1, data = res.cat)
ggsurvplot(fit, data = res.cat, risk.table = TRUE, conf.int = TRUE)

}
\author{
Alboukadel Kassambara, \email{alboukadel.kassambara@gmail.com}
}
