% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPCWdf.R
\name{IPCWdf}
\alias{IPCWdf}
\title{Inverse probability of censoring weighting estimator for the bivariate
distribution function.}
\usage{
IPCWdf(object, x, y, covariate, cov.value, bw, window = "gaussian")
}
\arguments{
\item{object}{An object of class multidf.}

\item{x}{The first time for obtaining estimates for the bivariate distribution
function.}

\item{y}{The second time for obtaining estimates for the bivariate distribution
function.}

\item{covariate}{Name of the quantitative covariate.}

\item{cov.value}{The value of the quantitative covariate.}

\item{bw}{A single numeric value to compute a kernel density bandwidth. Use 
\code{"dpik"} for the \pkg{KernSmooth} package based selector or \code{"np"} 
for the \code{'npudensbw'} function of the \pkg{np} package.}

\item{window}{A character string specifying the desired kernel. See details 
below for possible options. Defaults to \code{"gaussian"} where the gaussian 
density kernel will be used.}
}
\value{
Vector with the IPWC estimates for the bivariate distribution 
function.
}
\description{
Provides estimates for the bivariate distribution function based
on the Inverse Probability of Censoring Weighting estimator (IPCW).
}
\examples{
data("bladder4state")

b3state<-multidf(gap1=bladder4state$y1, event1=bladder4state$d1, 
                 gap2=bladder4state$y2, status=bladder4state$d2, 
                 size=bladder4state$size)         

b3size<-multidf(gap1=bladder3$t1, event1=bladder3$d1, 
                gap2=bladder3$t2-bladder3$t1,status=bladder4state$d2, 
                size=bladder3$size)  

library(KernSmooth)

IPCWdf(object=b3state, x=13, y=15, covariate="size", cov.value=3, 
       window = "gaussian")
       
IPCWdf(object=b3state, x=13, y=15, covariate="size", bw=2, cov.value=3, 
       window = "gaussian")

IPCWdf(object=b3size, x=13, y=15, covariate="size", cov.value=3, 
       window = "gaussian")
       
IPCWdf(object=b3size, x=13, y=15, covariate="size", bw=2, cov.value=3, 
       window = "gaussian")

}
\references{
de Una-Alvarez, J. and Meira-Machado, L. (2008). A simple estimator
of the bivariate distribution function for censored gap times, Statistics and
Probability Letters 78, 2440-2445.
}
\seealso{
\code{\link{KMWdf}}, \code{\link{LDMdf}}, \code{\link{LINdf}} and 
\code{\link{WCHdf}}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado.

Gustavo Soutinho and Luis Meira-Machado
}
