% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivALL.R
\name{survivALL}
\alias{survivALL}
\title{Calculate and combine hazard ratio, pvalue, threshold and
area-between-curve data as a single dataframe}
\usage{
survivALL(measure, srv, time = "Time", event = "Event", bs_dfr = c(),
  measure_name = "measure", multiv = NULL, n_sd = 1.96)
}
\arguments{
\item{measure}{A continuous variable used to order survival data. Samples
must be ordered exactly as in srv}

\item{srv}{A dataframe that contains at least two columns, detailing event 
and time to event information. 
Samples must be ordered exactly as in measure}

\item{time}{Column name in srv containing time to event information. Must 
not contain NAs}

\item{event}{Column name in srv containing event information coded as 0 (no
event) and 1 (event). Must not contain NAs}

\item{bs_dfr}{A matrix of bootstrapped hazard ratio computations as ordered
by a random measurement vector. Typically consisting of 5-10,000 repeat 
samplings}

\item{measure_name}{A descriptive name for the measure used, for example
a gene ID}

\item{multiv}{Univariate analysis is performed by default, however a vector 
of additional variables (corresponding to colnames in srv) can be included}

\item{n_sd}{The number of standard deviations used to define threshold width.
95% of random hazard ratio values fall within the thresholds with a standard 
deviation of 1.96}
}
\value{
a dataframe detailing survival, measure, hazard ratio,
pvalue, log10 pvalue, threshold and threshold residual information
}
\description{
Calculate and combine hazard ratio, pvalue, threshold and
area-between-curve data as a single dataframe
}
\examples{
library(survivALL)
data(nki_subset)
library(Biobase)
library(ggplot2)

gene_vec <- exprs(nki_subset)["NM_004448", ] #ERBB2 gene id

survivALL_dfr <- survivALL(measure = gene_vec, 
   srv = pData(nki_subset), 
   time = "t.dmfs", 
   event = "e.dmfs")

ggplot(survivALL_dfr, aes_string(x = 'index', y = 'p')) + 
    geom_hline(yintercept = 0.05, linetype = 3) + 
    geom_point()
}
