% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV2_00.r
\name{pwcst}
\alias{pwcst}
\title{Defining piecewise constant (excess) hazard in survPen formulae}
\usage{
pwcst(breaks)
}
\arguments{
\item{breaks}{numeric vector that specifies the boundaries of each sub-interval on which the hazard is constant}
}
\value{
object of class \code{pwcst.spec}
\item{pwcst.breaks}{numeric vector that specifies the boundaries of each sub-interval on which the hazard is constant}
}
\description{
Used inside a formula object to define a piecewise constant (excess) hazard. This is useful since it triggers an 
explicit calculation of cumulative hazard calculation (much more efficient and more precise than Gauss-Legendre
quadrature when hazard is constant).
The breaks given are used to defined sub-intervals that are left-open (except the first interval which is always 
left-closed) and right-closed. Internally, this constructor uses the cut function on the follow-up time with options 
include.lowest=TRUE and right=TRUE
Important : this function must not be used with other time-dependent effect functions because the Gauss-Legendre quadrature
will not operate correctly. If you really want to fit such a model, please use the cut function with the time variable as
an argument to fit a piecewise constant hazard (and do not forget to use a huge number of Gauss-Legendre quadrature nodes,
typically n.legendre=500)
}
\examples{
library(survPen)

data(datCancer)

# piece constant hazard on 6 sub-intervals : [0;0.5]; ]0.5;1]; ]1;2]; ]2;3]; ]3;4]; ]4;5]
formula <- ~pwcst(breaks=c(0,0.5,1,2,3,4,5))
mod <- survPen(formula,t1=fu,event=dead,data=datCancer)

# The same but in an inefficient way
formula2 <- ~cut(fu,breaks=c(0,0.5,1,2,3,4,5),include.lowest=TRUE,right=TRUE)
mod.inefficient <- survPen(formula2,t1=fu,event=dead,data=datCancer,n.legendre=500)

}
