% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV2_00.r
\name{splitmult}
\alias{splitmult}
\title{Split original dataset at specified times to fit a multiplicative model}
\usage{
splitmult(data, cut, start = NULL, end, event)
}
\arguments{
\item{data}{orginal datset}

\item{cut}{vector of timepoints to cut at (usually every year of follow-up)}

\item{start}{character string with name of start variable (will be created and set to zero if it does not exist)}

\item{end}{character string with name of event time variable}

\item{event}{character string with name of censoring indicator}
}
\value{
split dataset with follow-up time split at specified times. An 'id_row' column is added to identify original row numbers
}
\description{
This function allows splitting the original dataset in order to retrieve all the expected mortality rates available 
according to each individual's follow-up time. Typically, the expected mortality rates come from national mortality tables
and values are available for every combination of age and year (often with 1-year increment).
}
\details{
This function is close to the survsplit function proposed in relsurv package, but it is simpler since fewer features are needed.
}
\examples{
library(survPen)
data(datCancer)
data(expected.table)

#-------------------- creating split dataset for multiplicative model

splitdat <- splitmult(datCancer, cut = (1:5), end = "fu", 
event = "dead")
		
#-------------------- merging with expected mortality table

# deriving current age and year (closest whole number)
splitdat$age_current <- floor(splitdat$age + splitdat$fu + 0.5)

splitdat$year_current <- floor(splitdat$yod + splitdat$fu + 0.5)


splitdat <- merge(splitdat, expected.table, 
                by.x=c("age_current","year_current"), by.y=c("Age","Year"),all.x=TRUE)


}
