% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_51.r
\name{tensor.in}
\alias{tensor.in}
\title{tensor model matrix for two marginal bases}
\usage{
tensor.in(X1, X2)
}
\arguments{
\item{X1}{first marginal design matrix with n rows and p1 columns}

\item{X2}{first marginal design matrix with n rows and p2 columns}
}
\value{
Matrix of dimensions n*(p1*p2) representing the row tensor product of the matrices X1 and X2
}
\description{
Function called recursively inside \code{\link{tensor.prod.X}}.
}
\examples{

library(survPen)

# row-wise tensor product between two design matrices
set.seed(15)

X1 <- matrix(rnorm(10*3),nrow=10,ncol=3)
X2 <- matrix(rnorm(10*2),nrow=10,ncol=2)
tensor.in(X1,X2)

}
