% Generated by roxygen2 (4.0.1): do not edit by hand
\name{quantile}
\alias{median}
\alias{median.Surv}
\alias{median.coxph}
\alias{median.survfit}
\alias{quantile}
\alias{quantile.Surv}
\alias{quantile.coxph}
\alias{quantile.survfit}
\title{Quantiles and median for \code{Surv}, \code{survfit} and \code{coxph} objects}
\usage{
quantile(x, ...)

\method{quantile}{Surv}(x, ..., q = c(25, 50, 75), CI = TRUE,
  alpha = 0.05, ci = c("log", "lin", "asr"))

\method{quantile}{survfit}(x, ..., q = c(25, 50, 75), CI = TRUE,
  alpha = 0.05, ci = c("log", "lin", "asr"))

\method{quantile}{coxph}(x, ..., q = c(25, 50, 75), CI = TRUE,
  alpha = 0.05, ci = c("log", "lin", "asr"))

median(x, ...)

\method{median}{Surv}(x, ..., CI = FALSE, alpha = 0.05, ci = c("log",
  "lin", "asr"))

\method{median}{survfit}(x, ..., CI = FALSE, alpha = 0.05, ci = c("log",
  "lin", "asr"))

\method{median}{coxph}(x, ..., CI = FALSE, alpha = 0.05, ci = c("log",
  "lin", "asr"))
}
\arguments{
\item{x}{A \code{Surv}, \code{survfit} or \code{coxph} object.}

\item{...}{Additional arguments (not implemented).}

\item{q}{(for \code{quantile}) Vector of quantiles
(expressed as percentage). For the \code{median}, \code{q=50}.}

\item{CI}{Include confidence interval.
\cr
Defaults are \code{CI=TRUE} for \code{quantile} and
\code{CI=FALSE} for \code{median}.}

\item{alpha}{Significance level \eqn{\alpha}{alpha}.}

\item{ci}{\bold{C}onfidence \bold{i}nterval.
\cr
One of: \bold{log} (the default), \bold{lin}ear or \bold{a}rcsine-\bold{s}quare \bold{r}oot.}
}
\value{
For \code{quantile}:
A \code{data.table} (or a \code{list} of \code{data.table}s, one per stratum),
with columns:
  \item{q}{quantile}
  \item{t}{time}
If \code{CI = TRUE} then upper and lower confidence
intervals, as per argument \code{ci}).
 \item{l}{lower confidence limit}
 \item{u}{upper confidence limit}
For \code{median}:
A \code{data.table} with columns:
  \item{t}{time}
  \item{s}{stratum}
If \code{CI = TRUE} then a \code{list} of
\code{data.table}s, one per stratum, as above.
}
\description{
Extends \code{stats::quantile} and \code{stats::quantile} to
work with \code{Surv}, \code{survfit} and \code{coxph} objects.














}
\note{
If a time cannot be calculated, \code{NaN} is returned.
}
\examples{
data(bmt, package="KMsurv")
b1 <- bmt[bmt$group==1, ] # ALL patients
s1 <- Surv(time=b1$t2, event=b1$d3)
quantile(s1)
b1 <- bmt[bmt$group==2, ] # AML low-risk patients
s1 <- Surv(time=b1$t2, event=b1$d3)
quantile(s1)
b1 <- bmt[bmt$group==3, ] # AML high-risk patients
s1 <- Surv(time=b1$t2, event=b1$d3)
quantile(s1)
###
s1 <- survfit(Surv(t2, d3) ~ group, data=bmt)
quantile(s1)
c1 <- coxph(Surv(t2, d3)~ group, data=bmt)
quantile(c1)
b1 <- bmt[bmt$group==1, ] # ALL patients
s1 <- Surv(time=b1$t2, event=b1$d3)
median(s1)
median(s1, CI=TRUE)
data(bmt, package="KMsurv")
b1 <- bmt[bmt$group==1, ] # ALL patients
s1 <- survfit(Surv(t2, d3)~ group, data=bmt)
median(s1)
median(s1, ci="asr", CI=TRUE)
c1 <- coxph(Surv(t2, d3) ~ group, data=bmt)
median(c1)
}
\references{
Examples for quantiles are from:
Klein J, Moeschberger M 2003
\emph{Survival Analysis}, 2nd edition.
New York: Springer.
Example 4.2, pg 121.
}
\seealso{
Confidence intervals are calculated as shown in the pointwise confidence intervals
in \code{\link{ci}}.
}

